<?php
include('partials/_header.php');

// Fetch available bursaries
$api_url = $APIBASE."bursary/bursary_exec.php?action=list_available_bursaries";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$bursaries = json_decode($response);

// Fetch user's existing applications
$api_url = $APIBASE."bursary/bursary_exec.php?action=list_user_applications&email=".$un_encrypted;
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$user_applications = json_decode($response);

// Create a quick lookup for user's applications
$user_application_map = [];
if($user_applications && count($user_applications) > 0) {
    foreach($user_applications as $app) {
        $user_application_map[$app->bursary_id] = $app;
    }
}

// Handle search and filters
$search_results = [];
if(isset($_POST['search_bursaries'])) {
    $search_term = $_POST['search_term'];
    $filter_field = $_POST['filter_field'];
    
    if(!empty($search_term) && $bursaries && count($bursaries) > 0) {
        foreach($bursaries as $bursary) {
            $field_value = '';
            switch($filter_field) {
                case 'company':
                    $field_value = $bursary->company_name;
                    break;
                case 'field':
                    $field_value = $bursary->field_of_study;
                    break;
                case 'location':
                    $field_value = $bursary->location;
                    break;
                default:
                    $field_value = $bursary->bursary_name;
            }
            
            if(stripos($field_value, $search_term) !== false) {
                $search_results[] = $bursary;
            }
        }
    } else {
        $search_results = $bursaries;
    }
} else {
    $search_results = $bursaries;
}

// Handle filters
if(isset($_POST['filter_bursaries'])) {
    $filter_field = $_POST['filter_field'];
    $filter_value = $_POST['filter_value'];
    
    $temp_results = $search_results;
    $search_results = [];
    
    foreach($temp_results as $bursary) {
        $match = true;
        
        if(!empty($filter_field) && $filter_value != 'all') {
            switch($filter_field) {
                case 'field':
                    if($bursary->field_of_study != $filter_value) $match = false;
                    break;
                case 'year':
                    if($bursary->academic_year != $filter_value) $match = false;
                    break;
                case 'province':
                    if($bursary->province != $filter_value) $match = false;
                    break;
            }
        }
        
        if($match) {
            $search_results[] = $bursary;
        }
    }
}
?>

<div class="layout-page">
    <!-- Navbar -->
    <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
        <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
            <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
            </a>
        </div>

        <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
            <!-- Search -->
            <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                    <i class="bx bx-search fs-4 lh-0"></i>
                    <input type="text" class="form-control border-0 shadow-none" placeholder="Search bursaries..." aria-label="Search..." id="searchInput"/>
                </div>
            </div>
            <!-- /Search -->

            <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                    <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                        <div class="avatar avatar-online">
                            <?php if ($gender == "Male"){ ?>
                            <img src="assets/img/avatars/avatar-student-male.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } else { ?>
                            <img src="assets/img/avatars/avatar-student-female.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } ?>
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="dashboard.php?id=<?php echo $encrypted ?>">
                                <i class="bx bx-home me-2"></i>
                                <span class="align-middle">Dashboard</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="profile.php?id=<?php echo $encrypted ?>">
                                <i class="bx bx-user me-2"></i>
                                <span class="align-middle">My Profile</span>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="logout.php">
                                <i class="bx bx-power-off me-2"></i>
                                <span class="align-middle">Log Out</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <!--/ User -->
            </ul>
        </div>
    </nav>
    <!-- / Navbar -->

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Bursaries & Funding Opportunities</h3>
                                    <p class="mb-0">Discover available bursaries and funding opportunities for your studies</p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <a href="dashboard.php?id=<?php echo $encrypted ?>" class="btn btn-outline-secondary">
                                        <i class="bx bx-arrow-back me-1"></i> Back to Dashboard
                                    </a>
                                    <a href="my_applications.php?id=<?php echo $encrypted ?>" class="btn btn-primary">
                                        <i class="bx bx-file me-1"></i> My Applications
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Search and Filter Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="">
                                <div class="row">
                                    <div class="col-md-5 mb-3">
                                        <label for="search_term" class="form-label">Search Bursaries</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="search_term" name="search_term" placeholder="Search bursaries..." value="<?php echo isset($_POST['search_term']) ? $_POST['search_term'] : ''; ?>">
                                            <select class="form-select" name="filter_field" style="max-width: 150px;">
                                                <option value="name" <?php echo (isset($_POST['filter_field']) && $_POST['filter_field'] == 'name') ? 'selected' : ''; ?>>Bursary Name</option>
                                                <option value="company" <?php echo (isset($_POST['filter_field']) && $_POST['filter_field'] == 'company') ? 'selected' : ''; ?>>Company</option>
                                                <option value="field" <?php echo (isset($_POST['filter_field']) && $_POST['filter_field'] == 'field') ? 'selected' : ''; ?>>Field of Study</option>
                                                <option value="location" <?php echo (isset($_POST['filter_field']) && $_POST['filter_field'] == 'location') ? 'selected' : ''; ?>>Location</option>
                                            </select>
                                            <button type="submit" name="search_bursaries" class="btn btn-primary">Search</button>
                                        </div>
                                    </div>
                                    <div class="col-md-7">
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <label for="filter_field" class="form-label">Filter by Field</label>
                                                <select class="form-select" id="filter_field" name="filter_field">
                                                    <option value="all" <?php echo (isset($_POST['filter_field']) && $_POST['filter_field'] == 'all') ? 'selected' : ''; ?>>All Fields</option>
                                                    <option value="Engineering" <?php echo (isset($_POST['filter_field']) && $_POST['filter_field'] == 'Engineering') ? 'selected' : ''; ?>>Engineering</option>
                                                    <option value="Medicine" <?php echo (isset($_POST['filter_field']) && $_POST['filter_field'] == 'Medicine') ? 'selected' : ''; ?>>Medicine</option>
                                                    <option value="Business" <?php echo (isset($_POST['filter_field']) && $_POST['filter_field'] == 'Business') ? 'selected' : ''; ?>>Business</option>
                                                    <option value="IT" <?php echo (isset($_POST['filter_field']) && $_POST['filter_field'] == 'IT') ? 'selected' : ''; ?>>Information Technology</option>
                                                    <option value="Education" <?php echo (isset($_POST['filter_field']) && $_POST['filter_field'] == 'Education') ? 'selected' : ''; ?>>Education</option>
                                                </select>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label for="filter_value" class="form-label">Filter by Year</label>
                                                <select class="form-select" id="filter_value" name="filter_value">
                                                    <option value="all" <?php echo (isset($_POST['filter_value']) && $_POST['filter_value'] == 'all') ? 'selected' : ''; ?>>All Years</option>
                                                    <?php
                                                    $current_year = date('Y');
                                                    for($i = $current_year; $i <= $current_year + 2; $i++) {
                                                        echo '<option value="'.$i.'" '.((isset($_POST['filter_value']) && $_POST['filter_value'] == $i) ? 'selected' : '').'>'.$i.'</option>';
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="col-md-4 mb-3 d-flex align-items-end">
                                                <button type="submit" name="filter_bursaries" class="btn btn-outline-primary w-100">Apply Filters</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Search and Filter Section -->

            <!-- Bursaries Grid -->
            <div class="row mb-4">
                <?php if($search_results && count($search_results) > 0): ?>
                    <?php foreach($search_results as $bursary): 
                        $bursary_id = $bursary->bursary_id;
                        $has_applied = isset($user_application_map[$bursary_id]);
                        $application = $has_applied ? $user_application_map[$bursary_id] : null;
                        $days_remaining = floor((strtotime($bursary->application_deadline) - time()) / (60 * 60 * 24));
                    ?>
                    <div class="col-md-6 col-lg-4 mb-4">
                        <div class="card bursary-card h-100">
                            <div class="card-header position-relative">
                                <span class="badge bg-<?php echo $days_remaining < 7 ? 'danger' : ($days_remaining < 30 ? 'warning' : 'success'); ?> position-absolute top-0 end-0 m-2">
                                    <?php echo $days_remaining > 0 ? $days_remaining . ' days left' : 'Closed'; ?>
                                </span>
                                <h5 class="card-title mb-1"><?php echo $bursary->bursary_name; ?></h5>
                                <p class="text-muted mb-0">by <?php echo $bursary->company_name; ?></p>
                            </div>
                            <div class="card-body">
                                <div class="bursary-details mb-3">
                                    <div class="d-flex align-items-center mb-2">
                                        <i class="bx bx-money me-2 text-success"></i>
                                        <span>Coverage: <?php echo $bursary->coverage; ?></span>
                                    </div>
                                    <div class="d-flex align-items-center mb-2">
                                        <i class="bx bx-book me-2 text-primary"></i>
                                        <span>Field: <?php echo $bursary->field_of_study; ?></span>
                                    </div>
                                    <div class="d-flex align-items-center mb-2">
                                        <i class="bx bx-calendar me-2 text-info"></i>
                                        <span>Academic Year: <?php echo $bursary->academic_year; ?></span>
                                    </div>
                                    <div class="d-flex align-items-center mb-2">
                                        <i class="bx bx-time me-2 text-warning"></i>
                                        <span>Deadline: <?php echo date('M j, Y', strtotime($bursary->application_deadline)); ?></span>
                                    </div>
                                </div>
                                <p class="card-text"><?php echo strlen($bursary->description) > 120 ? substr($bursary->description, 0, 120) . '...' : $bursary->description; ?></p>
                            </div>
                            <div class="card-footer bg-transparent">
                                <?php if($has_applied): ?>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="badge bg-<?php echo $application->status == 'approved' ? 'success' : ($application->status == 'rejected' ? 'danger' : 'info'); ?>">
                                            <?php echo ucfirst($application->status); ?>
                                        </span>
                                        <small class="text-muted">Applied on <?php echo date('M j, Y', strtotime($application->application_date)); ?></small>
                                    </div>
                                <?php else: ?>
                                    <?php if($days_remaining > 0): ?>
                                        <div class="d-grid gap-2">
                                            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#applyModal" data-bursary-id="<?php echo $bursary->bursary_id; ?>" data-bursary-name="<?php echo $bursary->bursary_name; ?>">
                                                Apply Now
                                            </button>
                                            <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#viewModal" data-bursary-id="<?php echo $bursary->bursary_id; ?>">
                                                View Details
                                            </button>
                                        </div>
                                    <?php else: ?>
                                        <div class="d-grid">
                                            <button class="btn btn-secondary" disabled>Applications Closed</button>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body text-center py-5">
                                <i class="bx bx-search bx-lg text-muted mb-3"></i>
                                <h5 class="text-muted">No bursaries found</h5>
                                <p class="text-muted">Try adjusting your search criteria or check back later for new opportunities.</p>
                                <a href="bursaries.php?id=<?php echo $encrypted; ?>" class="btn btn-primary">Clear Filters</a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <!-- /Bursaries Grid -->

            <!-- Pagination -->
            <?php if($search_results && count($search_results) > 0): ?>
            <div class="row">
                <div class="col-12">
                    <nav aria-label="Page navigation">
                        <ul class="pagination justify-content-center">
                            <li class="page-item disabled">
                                <a class="page-link" href="#" tabindex="-1" aria-disabled="true">Previous</a>
                            </li>
                            <li class="page-item active"><a class="page-link" href="#">1</a></li>
                            <li class="page-item"><a class="page-link" href="#">2</a></li>
                            <li class="page-item"><a class="page-link" href="#">3</a></li>
                            <li class="page-item">
                                <a class="page-link" href="#">Next</a>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
            <?php endif; ?>
            <!-- /Pagination -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>

<!-- View Bursary Modal -->
<div class="modal fade" id="viewModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Bursary Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="bursaryDetails">
                <!-- Content will be loaded via AJAX -->
                <div class="text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="applyFromViewBtn">Apply Now</button>
            </div>
        </div>
    </div>
</div>

<!-- Apply for Bursary Modal -->
<div class="modal fade" id="applyModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Apply for Bursary</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="bursaryApplicationForm" method="POST" action="">
                <div class="modal-body">
                    <input type="hidden" id="applyBursaryId" name="bursary_id">
                    <div class="mb-3">
                        <label for="motivation" class="form-label">Motivation Letter</label>
                        <textarea class="form-control" id="motivation" name="motivation" rows="5" placeholder="Explain why you deserve this bursary and how it will help your studies..." required></textarea>
                        <div class="form-text">Minimum 200 characters. Explain your academic goals and financial need.</div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Required Documents</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="checkId" checked disabled>
                            <label class="form-check-label" for="checkId">ID Document (Uploaded)</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="checkAcademic" checked disabled>
                            <label class="form-check-label" for="checkAcademic">Academic Records (Uploaded)</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="checkProof" required>
                            <label class="form-check-label" for="checkProof">Proof of Household Income</label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" name="apply_bursary">Submit Application</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Application Success Modal -->
<div class="modal fade" id="successModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-success">Application Submitted</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <i class="bx bx-check-circle bx-lg text-success mb-3"></i>
                <h5>Application Successful!</h5>
                <p>Your bursary application has been submitted successfully. You can track its progress in your applications dashboard.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <a href="my_applications.php?id=<?php echo $encrypted; ?>" class="btn btn-primary">View My Applications</a>
            </div>
        </div>
    </div>
</div>

<style>
.bursary-card {
    transition: transform 0.2s, box-shadow 0.2s;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.bursary-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.bursary-details {
    border-left: 3px solid #4361ee;
    padding-left: 12px;
}

.pagination .page-item .page-link {
    border-radius: 8px;
    margin: 0 4px;
    border: none;
    color: #4361ee;
}

.pagination .page-item.active .page-link {
    background-color: #4361ee;
    border-color: #4361ee;
}
</style>

<!-- Core JS -->
<script src="assets/vendor/libs/jquery/jquery.js"></script>
<script src="assets/vendor/libs/popper/popper.js"></script>
<script src="assets/vendor/js/bootstrap.js"></script>
<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/js/menu.js"></script>
<script src="assets/js/main.js"></script>

<!-- Page JS -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // View bursary details modal
    const viewModal = document.getElementById('viewModal');
    viewModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const bursaryId = button.getAttribute('data-bursary-id');
        
        // Load bursary details via AJAX
        fetch(`<?php echo $APIBASE; ?>bursary/bursary_exec.php?action=get_bursary_details&id=${bursaryId}`)
            .then(response => response.json())
            .then(data => {
                if(data && data.length > 0) {
                    const bursary = data[0];
                    document.getElementById('bursaryDetails').innerHTML = `
                        <h4>${bursary.bursary_name}</h4>
                        <p class="text-muted">by ${bursary.company_name}</p>
                        
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <h6 class="card-title">Coverage</h6>
                                        <p class="card-text">${bursary.coverage}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <h6 class="card-title">Field of Study</h6>
                                        <p class="card-text">${bursary.field_of_study}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <h6>Description</h6>
                        <p>${bursary.description}</p>
                        
                        <h6>Eligibility Criteria</h6>
                        <p>${bursary.eligibility_criteria || 'No specific eligibility criteria provided.'}</p>
                        
                        <h6>Application Deadline</h6>
                        <p class="text-${new Date(bursary.application_deadline) > new Date() ? 'success' : 'danger'}">
                            ${new Date(bursary.application_deadline).toLocaleDateString()} 
                            (${Math.floor((new Date(bursary.application_deadline) - new Date()) / (1000 * 60 * 60 * 24))} days left)
                        </p>
                        
                        <h6>Contact Information</h6>
                        <p>Email: ${bursary.contact_email || 'N/A'}<br>
                        Phone: ${bursary.contact_phone || 'N/A'}</p>
                    `;
                    
                    // Set bursary ID for apply button
                    document.getElementById('applyFromViewBtn').setAttribute('data-bursary-id', bursaryId);
                }
            })
            .catch(error => {
                document.getElementById('bursaryDetails').innerHTML = `
                    <div class="alert alert-danger">
                        Failed to load bursary details. Please try again.
                    </div>
                `;
            });
    });
    
    // Apply from view modal
    document.getElementById('applyFromViewBtn').addEventListener('click', function() {
        const bursaryId = this.getAttribute('data-bursary-id');
        const applyModal = new bootstrap.Modal(document.getElementById('applyModal'));
        
        // Set bursary ID in apply form
        document.getElementById('applyBursaryId').value = bursaryId;
        
        // Close view modal and open apply modal
        bootstrap.Modal.getInstance(viewModal).hide();
        applyModal.show();
    });
    
    // Apply for bursary modal
    const applyModal = document.getElementById('applyModal');
    applyModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const bursaryId = button.getAttribute('data-bursary-id');
        const bursaryName = button.getAttribute('data-bursary-name');
        
        document.getElementById('applyBursaryId').value = bursaryId;
        document.querySelector('#applyModal .modal-title').textContent = `Apply for: ${bursaryName}`;
    });
    
    // Handle application form submission
    document.getElementById('bursaryApplicationForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        // Simple validation
        const motivation = document.getElementById('motivation').value;
        const proofCheck = document.getElementById('checkProof').checked;
        
        if(motivation.length < 200) {
            alert('Motivation letter must be at least 200 characters long.');
            return;
        }
        
        if(!proofCheck) {
            alert('Please confirm that you have uploaded Proof of Household Income.');
            return;
        }
        
        // Submit form via AJAX
        const formData = new FormData(this);
        formData.append('email', '<?php echo $un_encrypted; ?>');
        
        fetch('<?php echo $APIBASE; ?>bursary/bursary_exec.php?action=apply_bursary', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                // Close apply modal and show success modal
                bootstrap.Modal.getInstance(applyModal).hide();
                const successModal = new bootstrap.Modal(document.getElementById('successModal'));
                successModal.show();
                
                // Refresh page after 3 seconds
                setTimeout(() => {
                    window.location.reload();
                }, 3000);
            } else {
                alert('Failed to submit application. Please try again.');
            }
        })
        .catch(error => {
            alert('An error occurred. Please try again.');
        });
    });
    
    // Search functionality
    document.getElementById('searchInput').addEventListener('keyup', function() {
        const filter = this.value.toLowerCase();
        const cards = document.querySelectorAll('.bursary-card');
        
        cards.forEach(card => {
            const title = card.querySelector('.card-title').textContent.toLowerCase();
            const company = card.querySelector('.text-muted').textContent.toLowerCase();
            const text = card.querySelector('.card-text').textContent.toLowerCase();
            
            if(title.includes(filter) || company.includes(filter) || text.includes(filter)) {
                card.parentElement.style.display = '';
            } else {
                card.parentElement.style.display = 'none';
            }
        });
    });
});
</script>
</body>
</html>