<?php 
include('partials/_super_header.php');
?>

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <nav
            class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme"
            id="layout-navbar"
          >
            <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
              <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
              </a>
            </div>

            <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
              <!-- Search -->
              <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                  <i class="bx bx-search fs-4 lh-0"></i>
                  <input
                    type="text"
                    class="form-control border-0 shadow-none"
                    placeholder="Search..."
                    aria-label="Search..."
                  />
                </div>
              </div>
              <!-- /Search -->

              <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- Place this tag where you want the button to render. -->

                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                  <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                    <div class="avatar avatar-online">
                      <?php if ($gender == "Male"){ ?>
                      <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                      <?php } else { ?>
                      <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                      <?php } ?>
                    </div>
                  </a>
                  <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                      <a class="dropdown-item" href="#">
                        <div class="d-flex">
                          <div class="flex-shrink-0 me-3">
                            <div class="avatar avatar-online">
                              <?php if ($gender == "Male"){ ?>
                                <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                              <?php } else { ?>
                                <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                              <?php } ?>
                            </div>
                          </div>
                          <div class="flex-grow-1">
                            <span class="fw-semibold d-block"><?php echo $firstname.' '.$surname ?></span>
                            <small class="text-muted"><?php echo $user_role ?></small>
                          </div>
                        </div>
                      </a>
                    </li>
                    <li>
                      <div class="dropdown-divider"></div>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <i class="bx bx-user me-2"></i>
                        <span class="align-middle">My Profile</span>
                      </a>
                    </li>
                    <li>
                      <a class="dropdown-item" href="#">
                        <i class="bx bx-cog me-2"></i>
                        <span class="align-middle">Settings</span>
                      </a>
                    </li>
                    <li>
                      <div class="dropdown-divider"></div>
                    </li>
                    <li>
                      <a class="dropdown-item" href="logout.php">
                        <i class="bx bx-power-off me-2"></i>
                        <span class="align-middle">Log Out</span>
                      </a>
                    </li>
                  </ul>
                </li>
                <!--/ User -->
              </ul>
            </div>
          </nav>

          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">

              <div class="col-12 col-lg-12 order-2 order-md-3 order-lg-2 mb-4">
                <div class="card">
                  <div class="row row-bordered g-0">
                    <div class="col-md-12">
                      <h5 class="card-header m-0 me-2 pb-3">Compare Qualifications</h5>
                      
                      <!-- Qualification Selection Form -->
                      <div class="card-body">
                        <form id="compareForm" method="GET" action="">
                          <div class="row mb-3">
                            <div class="col-md-4">
                              <label for="qualification1" class="form-label">Select First Qualification</label>
                              <select class="form-select" id="qualification1" name="q1" required>
                                <option value="">-- Select Qualification --</option>
                                <option value="bcom" <?php echo (isset($_GET['q1']) && $_GET['q1'] == 'bcom') ? 'selected' : ''; ?>>Bachelor of Commerce (BCom)</option>
                                <option value="bsc" <?php echo (isset($_GET['q1']) && $_GET['q1'] == 'bsc') ? 'selected' : ''; ?>>Bachelor of Science (BSc)</option>
                                <option value="ba" <?php echo (isset($_GET['q1']) && $_GET['q1'] == 'ba') ? 'selected' : ''; ?>>Bachelor of Arts (BA)</option>
                                <option value="beng" <?php echo (isset($_GET['q1']) && $_GET['q1'] == 'beng') ? 'selected' : ''; ?>>Bachelor of Engineering (BEng)</option>
                              </select>
                            </div>
                            <div class="col-md-4">
                              <label for="qualification2" class="form-label">Select Second Qualification</label>
                              <select class="form-select" id="qualification2" name="q2" required>
                                <option value="">-- Select Qualification --</option>
                                <option value="bcom" <?php echo (isset($_GET['q2']) && $_GET['q2'] == 'bcom') ? 'selected' : ''; ?>>Bachelor of Commerce (BCom)</option>
                                <option value="bsc" <?php echo (isset($_GET['q2']) && $_GET['q2'] == 'bsc') ? 'selected' : ''; ?>>Bachelor of Science (BSc)</option>
                                <option value="ba" <?php echo (isset($_GET['q2']) && $_GET['q2'] == 'ba') ? 'selected' : ''; ?>>Bachelor of Arts (BA)</option>
                                <option value="beng" <?php echo (isset($_GET['q2']) && $_GET['q2'] == 'beng') ? 'selected' : ''; ?>>Bachelor of Engineering (BEng)</option>
                              </select>
                            </div>
                            <div class="col-md-4">
                              <label for="qualification3" class="form-label">Select Third Qualification (Optional)</label>
                              <select class="form-select" id="qualification3" name="q3">
                                <option value="">-- Select Qualification --</option>
                                <option value="bcom" <?php echo (isset($_GET['q3']) && $_GET['q3'] == 'bcom') ? 'selected' : ''; ?>>Bachelor of Commerce (BCom)</option>
                                <option value="bsc" <?php echo (isset($_GET['q3']) && $_GET['q3'] == 'bsc') ? 'selected' : ''; ?>>Bachelor of Science (BSc)</option>
                                <option value="ba" <?php echo (isset($_GET['q3']) && $_GET['q3'] == 'ba') ? 'selected' : ''; ?>>Bachelor of Arts (BA)</option>
                                <option value="beng" <?php echo (isset($_GET['q3']) && $_GET['q3'] == 'beng') ? 'selected' : ''; ?>>Bachelor of Engineering (BEng)</option>
                              </select>
                            </div>
                          </div>
                          <button type="submit" class="btn btn-primary">
                            <i class="bx bx-compare me-1"></i> Compare Qualifications
                          </button>
                        </form>
                      </div>
                      
                      <!-- Comparison Results (Only shown after form submission) -->
                      <?php if (isset($_GET['q1']) && isset($_GET['q2'])): ?>
                      <div class="card-body">
                        <h5 class="mb-4">Comparison Results</h5>
                        
                        <!-- Qualification Cards -->
                        <div class="row mb-4">
                          <div class="col-md-4">
                            <div class="card h-100">
                              <div class="card-body">
                                <h5 class="card-title">Bachelor of Commerce</h5>
                                <h6 class="card-subtitle mb-2 text-muted">University of Cape Town</h6>
                                <p class="card-text">A comprehensive business degree focusing on economics, finance, and management principles.</p>
                                <ul class="list-unstyled">
                                  <li><strong>Duration:</strong> 3 years</li>
                                  <li><strong>NQF Level:</strong> 7</li>
                                  <li><strong>Annual Tuition:</strong> R64,500</li>
                                </ul>
                              </div>
                            </div>
                          </div>
                          <div class="col-md-4">
                            <div class="card h-100">
                              <div class="card-body">
                                <h5 class="card-title">Bachelor of Science</h5>
                                <h6 class="card-subtitle mb-2 text-muted">University of the Witwatersrand</h6>
                                <p class="card-text">A science degree with specializations in physics, chemistry, biology, and mathematics.</p>
                                <ul class="list-unstyled">
                                  <li><strong>Duration:</strong> 3 years</li>
                                  <li><strong>NQF Level:</strong> 7</li>
                                  <li><strong>Annual Tuition:</strong> R58,200</li>
                                </ul>
                              </div>
                            </div>
                          </div>
                          <div class="col-md-4">
                            <?php if (isset($_GET['q3']) && !empty($_GET['q3'])): ?>
                            <div class="card h-100">
                              <div class="card-body">
                                <h5 class="card-title">Bachelor of Engineering</h5>
                                <h6 class="card-subtitle mb-2 text-muted">University of Pretoria</h6>
                                <p class="card-text">An engineering degree with specializations in civil, electrical, mechanical, and chemical engineering.</p>
                                <ul class="list-unstyled">
                                  <li><strong>Duration:</strong> 4 years</li>
                                  <li><strong>NQF Level:</strong> 8</li>
                                  <li><strong>Annual Tuition:</strong> R71,300</li>
                                </ul>
                              </div>
                            </div>
                            <?php else: ?>
                            <div class="card h-100">
                              <div class="card-body">
                                <h5 class="card-title">Not Selected</h5>
                                <h6 class="card-subtitle mb-2 text-muted">Select a qualification to compare</h6>
                                <p class="card-text">Choose a third qualification from the dropdown to compare it with the others.</p>
                              </div>
                            </div>
                            <?php endif; ?>
                          </div>
                        </div>
                        
                        <!-- Comparison Table -->
                        <div class="table-responsive">
                          <table class="table table-bordered">
                            <thead>
                              <tr>
                                <th style="width: 25%">Criteria</th>
                                <th style="width: 25%">Bachelor of Commerce</th>
                                <th style="width: 25%">Bachelor of Science</th>
                                <th style="width: 25%">
                                  <?php if (isset($_GET['q3']) && !empty($_GET['q3'])): ?>
                                  Bachelor of Engineering
                                  <?php else: ?>
                                  Qualification 3
                                  <?php endif; ?>
                                </th>
                              </tr>
                            </thead>
                            <tbody>
                              <tr>
                                <td><strong>Full Name</strong></td>
                                <td>Bachelor of Commerce (BCom)</td>
                                <td>Bachelor of Science (BSc)</td>
                                <td>
                                  <?php if (isset($_GET['q3']) && !empty($_GET['q3'])): ?>
                                  Bachelor of Engineering (BEng)
                                  <?php else: ?>
                                  -
                                  <?php endif; ?>
                                </td>
                              </tr>
                              <tr>
                                <td><strong>Institution</strong></td>
                                <td>University of Cape Town</td>
                                <td>University of the Witwatersrand</td>
                                <td>
                                  <?php if (isset($_GET['q3']) && !empty($_GET['q3'])): ?>
                                  University of Pretoria
                                  <?php else: ?>
                                  -
                                  <?php endif; ?>
                                </td>
                              </tr>
                              <tr>
                                <td><strong>Duration</strong></td>
                                <td>3 years full-time</td>
                                <td>3 years full-time</td>
                                <td>
                                  <?php if (isset($_GET['q3']) && !empty($_GET['q3'])): ?>
                                  4 years full-time
                                  <?php else: ?>
                                  -
                                  <?php endif; ?>
                                </td>
                              </tr>
                              <tr>
                                <td><strong>Prerequisites</strong></td>
                                <td>Mathematics (60%+), English Home Language (50%+) or First Additional Language (60%+)</td>
                                <td>Mathematics (70%+), Physical Science (60%+)</td>
                                <td>
                                  <?php if (isset($_GET['q3']) && !empty($_GET['q3'])): ?>
                                  Mathematics (80%+), Physical Science (70%+)
                                  <?php else: ?>
                                  -
                                  <?php endif; ?>
                                </td>
                              </tr>
                              <tr>
                                <td><strong>Annual Tuition</strong></td>
                                <td>R64,500</td>
                                <td>R58,200</td>
                                <td>
                                  <?php if (isset($_GET['q3']) && !empty($_GET['q3'])): ?>
                                  R71,300
                                  <?php else: ?>
                                  -
                                  <?php endif; ?>
                                </td>
                              </tr>
                              <tr>
                                <td><strong>Application Deadline</strong></td>
                                <td>30 September 2023</td>
                                <td>31 October 2023</td>
                                <td>
                                  <?php if (isset($_GET['q3']) && !empty($_GET['q3'])): ?>
                                  30 August 2023
                                  <?php else: ?>
                                  -
                                  <?php endif; ?>
                                </td>
                              </tr>
                              <tr>
                                <td><strong>Career Paths</strong></td>
                                <td>Accountant, Financial Analyst, Business Consultant, Marketing Manager</td>
                                <td>Research Scientist, Data Analyst, Laboratory Technician, Biotechnologist</td>
                                <td>
                                  <?php if (isset($_GET['q3']) && !empty($_GET['q3'])): ?>
                                  Civil Engineer, Electrical Engineer, Mechanical Engineer, Chemical Engineer
                                  <?php else: ?>
                                  -
                                  <?php endif; ?>
                                </td>
                              </tr>
                              <tr>
                                <td><strong>Delivery Mode</strong></td>
                                <td>On-campus</td>
                                <td>On-campus</td>
                                <td>
                                  <?php if (isset($_GET['q3']) && !empty($_GET['q3'])): ?>
                                  On-campus
                                  <?php else: ?>
                                  -
                                  <?php endif; ?>
                                </td>
                              </tr>
                              <tr>
                                <td><strong>Accreditation</strong></td>
                                <td>CHE & SAICA</td>
                                <td>CHE & ASSAf</td>
                                <td>
                                  <?php if (isset($_GET['q3']) && !empty($_GET['q3'])): ?>
                                  CHE & ECSA
                                  <?php else: ?>
                                  -
                                  <?php endif; ?>
                                </td>
                              </tr>
                              <tr class="table-active">
                                <td><strong>Employment Rate</strong></td>
                                <td>92% within 6 months of graduation</td>
                                <td>88% within 6 months of graduation</td>
                                <td>
                                  <?php if (isset($_GET['q3']) && !empty($_GET['q3'])): ?>
                                  95% within 6 months of graduation
                                  <?php else: ?>
                                  -
                                  <?php endif; ?>
                                </td>
                              </tr>
                            </tbody>
                          </table>
                        </div>
                      </div>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <!-- / Content -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

    <script src="assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/js/dashboards-analytics.js"></script>

    <!-- Place this tag in your head or just before your close body tag. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
  </body>
</html>