<?php
include('partials/_corporate_header.php');

// Get current user ID from session
$created_by = $_SESSION['user_id'] ?? 1;
$company_name = $_SESSION['company_name'] ?? $db_company_name;
?>

<div class="layout-page">
    <!-- Navbar -->
    
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Add New Bursary Program</h3>
                                    <p class="mb-0">Create a new bursary program for <?php echo $db_company_name; ?></p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <a href="corporate_manage_bursaries.php?id=<?php echo toURL(rand()) ?>" class="btn btn-outline-secondary">
                                        <i class="bx bx-list-ul me-1"></i> View Bursaries
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Bursary Form -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Bursary Program Details</h5>
                        </div>
                        <div class="card-body">
                            <form id="bursaryForm" action="<?php echo $APIBASE; ?>users/users_exec.php?action=add_bursary_program" method="POST">
                                <input type="hidden" name="created_by" value="<?php echo $created_by; ?>">
                                <input type="hidden" name="funder_name" value="<?php echo $db_company_name; ?>">
                                
                                <div class="row mb-3">
                                    <div class="col-md-12">
                                        <label class="form-label">Bursary Program Name *</label>
                                        <input type="text" class="form-control" name="project_name" required placeholder="e.g., Engineering Bursary 2024">
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label class="form-label">Contact Person *</label>
                                        <input type="text" class="form-control" name="contact_person" required value="<?php echo $firstname.' '.$surname; ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Contact Email *</label>
                                        <input type="email" class="form-control" name="contact_email" required value="<?php echo $email; ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Contact Phone *</label>
                                        <input type="tel" class="form-control" name="contact_phone" required placeholder="e.g., 012 345 6789">
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label class="form-label">Application End Date *</label>
                                        <input type="date" class="form-control" name="application_end_date" required min="<?php echo date('Y-m-d'); ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Funding Amount (ZAR)</label>
                                        <input type="number" class="form-control" name="funding_amount" step="0.01" placeholder="e.g., 50000.00">
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">Field of Study</label>
                                        <input type="text" class="form-control" name="field_of_study" placeholder="e.g., Engineering, Medicine, etc.">
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Academic Requirements</label>
                                        <textarea class="form-control" name="academic_requirements" rows="3" placeholder="Minimum academic requirements..."></textarea>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Demographic Filters</label>
                                        <textarea class="form-control" name="demographic_filters" rows="3" placeholder="Gender, race, location requirements..."></textarea>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-12">
                                        <label class="form-label">Basic Requirements</label>
                                        <textarea class="form-control" name="basic_requirements" rows="4" placeholder="Basic application requirements..."></textarea>
                                    </div>
                                </div>

                                <div class="row mb-4">
                                    <div class="col-12">
                                        <label class="form-label">Terms & Conditions</label>
                                        <textarea class="form-control" name="terms_conditions" rows="5" placeholder="Program terms and conditions..."></textarea>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bx bx-save me-1"></i> Create Bursary Program
                                        </button>
                                        <button type="reset" class="btn btn-outline-secondary">
                                            <i class="bx bx-reset me-1"></i> Reset Form
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Bursary Form -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>

<!-- Form Validation Script -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('bursaryForm');
    
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        // Basic validation
        const requiredFields = form.querySelectorAll('[required]');
        let valid = true;
        
        requiredFields.forEach(field => {
            if (!field.value.trim()) {
                valid = false;
                field.classList.add('is-invalid');
            } else {
                field.classList.remove('is-invalid');
            }
        });
        
        if (valid) {
            // Submit form via AJAX
            const formData = new FormData(form);
            
            fetch(form.action, {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data[0].success === '1') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: 'Bursary program created successfully!',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        window.location.href = 'corporate_manage_bursaries.php?id=<?php echo toURL(rand()) ?>';
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Failed to create bursary program. Please try again.',
                        confirmButtonText: 'OK'
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: 'An error occurred. Please try again.',
                    confirmButtonText: 'OK'
                });
            });
        }
    });
});
</script>

<?php include('partials/_corporate_footer.php'); ?>