<?php
include('partials/_corporate_header.php');

$encrypted_id = $_GET['id'];
$un_encrypted_id = fromURL($_GET['id']);

// Fetch corporate details
$api_url = $APIBASE."users/users_exec.php?action=view_corporates_by_id&id=".$un_encrypted_id."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$corporateDetails = json_decode($response);

if($corporateDetails && count($corporateDetails) > 0){
    foreach($corporateDetails as $row) {        
        $bur_prv_id = $row->bur_prv_id;
        $db_company_name = $row->company_name;
        $company_registration = $row->company_registration;
        $company_address = $row->company_address;
        $company_contact_number = $row->company_contact_number;
        $province = $row->province;
        $district = $row->district;
        $municipality = $row->municipality;
        $admin_firstname = $row->admin_firstname;
        $admin_surname = $row->admin_surname;
        $admin_email = $row->admin_email;
        $admin_contact_number = $row->admin_contact_number;
        $bursary_portal = $row->bursary_portal;
        $db_search = $row->db_search;
    }
}

// Handle form submissions
$update_success = '';
$update_error = '';

// Update company profile
if(isset($_POST['update_company_profile'])) {
    $company_name = $_POST['company_name'];
    $company_registration = $_POST['company_registration'];
    $company_address = $_POST['company_address'];
    $company_contact_number = $_POST['company_contact_number'];
    $province = $_POST['province'];
    $district = $_POST['district'];
    $municipality = $_POST['municipality'];
    
    // In a real implementation, you would make an API call to update the company profile
    // For now, we'll simulate a successful update
    $update_success = "Company profile updated successfully!";
}

// Update admin details
if(isset($_POST['update_admin_details'])) {
    $admin_firstname = $_POST['admin_firstname'];
    $admin_surname = $_POST['admin_surname'];
    $admin_email = $_POST['admin_email'];
    $admin_contact_number = $_POST['admin_contact_number'];
    
    // In a real implementation, you would make an API call to update the admin details
    // For now, we'll simulate a successful update
    $update_success = "Administrator details updated successfully!";
}

// Update preferences
if(isset($_POST['update_preferences'])) {
    $bursary_portal = isset($_POST['bursary_portal']) ? 'Yes' : 'No';
    $db_search = isset($_POST['db_search']) ? 'Yes' : 'No';
    
    // In a real implementation, you would make an API call to update the preferences
    // For now, we'll simulate a successful update
    $update_success = "Preferences updated successfully!";
}

// Change password
if(isset($_POST['change_password'])) {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];
    
    if($new_password !== $confirm_password) {
        $update_error = "New passwords do not match!";
    } else {
        // In a real implementation, you would verify the current password and update it
        // For now, we'll simulate a successful update
        $update_success = "Password changed successfully!";
    }
}
?>

<div class="layout-page">
    <!-- Navbar -->
    <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
        <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
            <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
            </a>
        </div>

        <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
            <!-- Search -->
            <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                    <i class="bx bx-search fs-4 lh-0"></i>
                    <input
                        type="text"
                        class="form-control border-0 shadow-none"
                        placeholder="Search settings..."
                        aria-label="Search..."
                    />
                </div>
            </div>
            <!-- /Search -->

            <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                    <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                        <div class="avatar avatar-online">
                            <?php if ($gender == "Male"){ ?>
                            <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } else { ?>
                            <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } ?>
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="#">
                                <div class="d-flex">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="avatar avatar-online">
                                            <?php if ($gender == "Male"){ ?>
                                                <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } else { ?>
                                                <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span class="fw-semibold d-block"><?php echo $firstname.' '.$surname ?></span>
                                        <small class="text-muted"><?php echo $user_role ?></small>
                                    </div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-user me-2"></i>
                                <span class="align-middle">My Profile</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-cog me-2"></i>
                                <span class="align-middle">Settings</span>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="logout.php">
                                <i class="bx bx-power-off me-2"></i>
                                <span class="align-middle">Log Out</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <!--/ User -->
            </ul>
        </div>
    </nav>
    <!-- / Navbar -->

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Corporate Settings</h3>
                                    <p class="mb-0">Manage your organization's settings and preferences</p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <a href="corporate_dashboard.php?id=<?php echo $encrypted_id ?>" class="btn btn-outline-secondary">
                                        <i class="bx bx-arrow-back me-1"></i> Back to Dashboard
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Alert Messages -->
            <?php if(!empty($update_success)): ?>
            <div class="alert alert-success alert-dismissible mb-4" role="alert">
                <i class="bx bx-check-circle me-2"></i> <?php echo $update_success; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            
            <?php if(!empty($update_error)): ?>
            <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                <i class="bx bx-error-circle me-2"></i> <?php echo $update_error; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            <!-- /Alert Messages -->

            <!-- Company Profile Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Company Profile</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="company_name" class="form-label">Company Name</label>
                                        <input type="text" class="form-control" id="company_name" name="company_name" value="<?php echo $db_company_name; ?>" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="company_registration" class="form-label">Company Registration Number</label>
                                        <input type="text" class="form-control" id="company_registration" name="company_registration" value="<?php echo $company_registration; ?>" required>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label for="company_address" class="form-label">Company Address</label>
                                    <textarea class="form-control" id="company_address" name="company_address" rows="3" required><?php echo $company_address; ?></textarea>
                                </div>
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label for="province" class="form-label">Province</label>
                                        <select class="form-select" id="province" name="province" required>
                                            <option value="">Select Province</option>
                                            <option value="Eastern Cape" <?php echo $province == 'Eastern Cape' ? 'selected' : ''; ?>>Eastern Cape</option>
                                            <option value="Free State" <?php echo $province == 'Free State' ? 'selected' : ''; ?>>Free State</option>
                                            <option value="Gauteng" <?php echo $province == 'Gauteng' ? 'selected' : ''; ?>>Gauteng</option>
                                            <option value="KwaZulu-Natal" <?php echo $province == 'KwaZulu-Natal' ? 'selected' : ''; ?>>KwaZulu-Natal</option>
                                            <option value="Limpopo" <?php echo $province == 'Limpopo' ? 'selected' : ''; ?>>Limpopo</option>
                                            <option value="Mpumalanga" <?php echo $province == 'Mpumalanga' ? 'selected' : ''; ?>>Mpumalanga</option>
                                            <option value="Northern Cape" <?php echo $province == 'Northern Cape' ? 'selected' : ''; ?>>Northern Cape</option>
                                            <option value="North West" <?php echo $province == 'North West' ? 'selected' : ''; ?>>North West</option>
                                            <option value="Western Cape" <?php echo $province == 'Western Cape' ? 'selected' : ''; ?>>Western Cape</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="district" class="form-label">District</label>
                                        <input type="text" class="form-control" id="district" name="district" value="<?php echo $district; ?>">
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="municipality" class="form-label">Municipality</label>
                                        <input type="text" class="form-control" id="municipality" name="municipality" value="<?php echo $municipality; ?>">
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label for="company_contact_number" class="form-label">Company Contact Number</label>
                                    <input type="tel" class="form-control" id="company_contact_number" name="company_contact_number" value="<?php echo $company_contact_number; ?>" required>
                                </div>
                                <button type="submit" name="update_company_profile" class="btn btn-primary">Update Company Profile</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Company Profile Section -->

            <!-- Administrator Details Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Primary Administrator Details</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="admin_firstname" class="form-label">First Name</label>
                                        <input type="text" class="form-control" id="admin_firstname" name="admin_firstname" value="<?php echo $admin_firstname; ?>" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="admin_surname" class="form-label">Surname</label>
                                        <input type="text" class="form-control" id="admin_surname" name="admin_surname" value="<?php echo $admin_surname; ?>" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="admin_email" class="form-label">Email Address</label>
                                        <input type="email" class="form-control" id="admin_email" name="admin_email" value="<?php echo $admin_email; ?>" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="admin_contact_number" class="form-label">Contact Number</label>
                                        <input type="tel" class="form-control" id="admin_contact_number" name="admin_contact_number" value="<?php echo $admin_contact_number; ?>" required>
                                    </div>
                                </div>
                                <button type="submit" name="update_admin_details" class="btn btn-primary">Update Administrator Details</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Administrator Details Section -->

            <!-- Preferences Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">System Preferences</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <div class="row">
                                    <div class="col-md-6 mb-4">
                                        <h6 class="mb-3">Bursary Portal Access</h6>
                                        <div class="form-check form-switch mb-2">
                                            <input class="form-check-input" type="checkbox" id="bursary_portal" name="bursary_portal" <?php echo $bursary_portal == 'Yes' ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="bursary_portal">
                                                Enable Bursary Portal
                                            </label>
                                        </div>
                                        <p class="text-muted small">When enabled, students can apply for bursaries directly through your portal.</p>
                                    </div>
                                    <div class="col-md-6 mb-4">
                                        <h6 class="mb-3">Database Search</h6>
                                        <div class="form-check form-switch mb-2">
                                            <input class="form-check-input" type="checkbox" id="db_search" name="db_search" <?php echo $db_search == 'Yes' ? 'checked' : ''; ?>>
                                            <label class="form-check-label" for="db_search">
                                                Enable Database Search
                                            </label>
                                        </div>
                                        <p class="text-muted small">When enabled, your organization can search the student database for potential candidates.</p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="notification_email" class="form-label">Notification Email</label>
                                        <input type="email" class="form-control" id="notification_email" value="<?php echo $admin_email; ?>">
                                        <div class="form-text">Email address where notifications will be sent</div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="report_frequency" class="form-label">Report Frequency</label>
                                        <select class="form-select" id="report_frequency">
                                            <option value="weekly">Weekly</option>
                                            <option value="monthly" selected>Monthly</option>
                                            <option value="quarterly">Quarterly</option>
                                            <option value="yearly">Yearly</option>
                                        </select>
                                        <div class="form-text">How often you want to receive automated reports</div>
                                    </div>
                                </div>
                                <button type="submit" name="update_preferences" class="btn btn-primary">Update Preferences</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Preferences Section -->

            <!-- Security Section -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Security Settings</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="current_password" class="form-label">Current Password</label>
                                        <input type="password" class="form-control" id="current_password" name="current_password" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="new_password" class="form-label">New Password</label>
                                        <input type="password" class="form-control" id="new_password" name="new_password" required>
                                        <div class="password-strength mt-2">
                                            <div class="progress mb-1" style="height: 5px;">
                                                <div class="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                            <small class="text-muted">Password strength: <span id="password-strength-text">Weak</span></small>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="confirm_password" class="form-label">Confirm New Password</label>
                                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                                        <div class="form-text" id="password-match-text">Passwords must match</div>
                                    </div>
                                </div>
                                <button type="submit" name="change_password" class="btn btn-primary">Change Password</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Security Section -->

            <!-- Danger Zone Section -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0 text-danger">Danger Zone</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <h6 class="mb-3">Export Data</h6>
                                    <p class="text-muted">Export all your organization's data in various formats.</p>
                                    <button class="btn btn-outline-secondary">Export Data</button>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <h6 class="mb-3">Deactivate Account</h6>
                                    <p class="text-muted">Temporarily deactivate your organization's account.</p>
                                    <button class="btn btn-outline-warning" data-bs-toggle="modal" data-bs-target="#deactivateModal">Deactivate Account</button>
                                </div>
                            </div>
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h6 class="mb-3 text-danger">Delete Account</h6>
                                    <p class="text-muted">Permanently delete your organization's account and all associated data. This action cannot be undone.</p>
                                    <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">Delete Account</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Danger Zone Section -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>

<!-- Deactivate Account Modal -->
<div class="modal fade" id="deactivateModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Deactivate Account</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to deactivate your account?</p>
                <p class="text-muted">Your account will be temporarily disabled, and you won't be able to access any features until you reactivate it.</p>
                <div class="mb-3">
                    <label for="deactivateReason" class="form-label">Reason for deactivation</label>
                    <textarea class="form-control" id="deactivateReason" rows="3"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-warning">Deactivate Account</button>
            </div>
        </div>
    </div>
</div>

<!-- Delete Account Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-danger">Delete Account</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p class="text-danger"><strong>Warning: This action cannot be undone!</strong></p>
                <p>All your organization's data, including beneficiary information, financial records, and administrator accounts will be permanently deleted.</p>
                <div class="mb-3">
                    <label for="deleteConfirm" class="form-label">Type "DELETE" to confirm</label>
                    <input type="text" class="form-control" id="deleteConfirm" placeholder="DELETE">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmDeleteBtn" disabled>Permanently Delete Account</button>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
.stat-card {
    transition: transform 0.2s, box-shadow 0.2s;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.stat-title {
    font-size: 0.875rem;
    color: #6c757d;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.stat-change {
    font-size: 0.75rem;
    font-weight: 500;
}

.stat-icon {
    font-size: 1.5rem;
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #6c757d;
    font-size: 0.875rem;
    text-transform: uppercase;
}

.table td {
    vertical-align: middle;
}

.card {
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.card-header {
    border-bottom: 1px solid #e9ecef;
    background-color: white;
}

.avatar-sm {
    width: 2.5rem;
    height: 2.5rem;
}

.password-strength .progress-bar {
    transition: width 0.3s ease;
}
</style>

<!-- Core JS -->
<script src="assets/vendor/libs/jquery/jquery.js"></script>
<script src="assets/vendor/libs/popper/popper.js"></script>
<script src="assets/vendor/js/bootstrap.js"></script>
<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/js/menu.js"></script>
<script src="assets/js/main.js"></script>

<!-- Page JS -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Password strength indicator
    const passwordInput = document.getElementById('new_password');
    const strengthBar = document.querySelector('.password-strength .progress-bar');
    const strengthText = document.getElementById('password-strength-text');
    
    if (passwordInput) {
        passwordInput.addEventListener('input', function() {
            const password = this.value;
            let strength = 0;
            
            // Check password strength
            if (password.length >= 8) strength += 25;
            if (password.match(/[a-z]+/)) strength += 25;
            if (password.match(/[A-Z]+/)) strength += 25;
            if (password.match(/[0-9]+/)) strength += 25;
            
            // Update strength bar
            strengthBar.style.width = strength + '%';
            
            // Update strength text
            if (strength < 50) {
                strengthBar.className = 'progress-bar bg-danger';
                strengthText.textContent = 'Weak';
            } else if (strength < 75) {
                strengthBar.className = 'progress-bar bg-warning';
                strengthText.textContent = 'Medium';
            } else {
                strengthBar.className = 'progress-bar bg-success';
                strengthText.textContent = 'Strong';
            }
        });
    }
    
    // Password match validation
    const confirmPasswordInput = document.getElementById('confirm_password');
    const passwordMatchText = document.getElementById('password-match-text');
    
    if (confirmPasswordInput && passwordInput) {
        confirmPasswordInput.addEventListener('input', function() {
            if (this.value !== passwordInput.value) {
                this.classList.add('is-invalid');
                passwordMatchText.classList.add('text-danger');
                passwordMatchText.textContent = 'Passwords do not match';
            } else {
                this.classList.remove('is-invalid');
                passwordMatchText.classList.remove('text-danger');
                passwordMatchText.classList.add('text-success');
                passwordMatchText.textContent = 'Passwords match';
            }
        });
    }
    
    // Delete account confirmation
    const deleteConfirmInput = document.getElementById('deleteConfirm');
    const confirmDeleteBtn = document.getElementById('confirmDeleteBtn');
    
    if (deleteConfirmInput && confirmDeleteBtn) {
        deleteConfirmInput.addEventListener('input', function() {
            confirmDeleteBtn.disabled = this.value !== 'DELETE';
        });
    }
    
    // Form validation
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            // Add your form validation logic here
            // For now, we'll just allow the form to submit
        });
    });
});
</script>
</body>
</html>