<?php 
include('partials/_super_header.php');

// Fetch dashboard stats
$api_url = $APIBASE."users/users_exec.php?action=view_super_user_dashboard";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$result = json_decode($response);

if($result && count($result) > 0){
    foreach($result as $row) {
        $total_number_of_users = $row->total_number_of_users;
        $total_new_registrations = $row->total_new_registrations;
        $total_corporate = $row->total_corporate;
        $total_super_user = $row->total_super_user;
        $total_inprogress_users = $row->total_inprogress_users;
        $registrations_today = $row->registrations_today;
        $total_full_registrations = $row->total_full_registrations;
    }
}
?>

<!-- Layout container -->
<div class="layout-page">
    <!-- Navbar -->
    <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
        <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
            <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                <i class="bx bx-menu bx-sm"></i>
            </a>
        </div>

        <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
            <!-- Search -->
            <div class="navbar-nav align-items-center">
                <div class="nav-item d-flex align-items-center">
                    <i class="bx bx-search fs-4 lh-0"></i>
                    <input
                        type="text"
                        class="form-control border-0 shadow-none"
                        placeholder="Search candidates..."
                        aria-label="Search..."
                    />
                </div>
            </div>
            <!-- /Search -->

            <ul class="navbar-nav flex-row align-items-center ms-auto">
                <!-- User -->
                <li class="nav-item navbar-dropdown dropdown-user dropdown">
                    <a class="nav-link dropdown-toggle hide-arrow" href="javascript:void(0);" data-bs-toggle="dropdown">
                        <div class="avatar avatar-online">
                            <?php if ($gender == "Male"){ ?>
                            <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } else { ?>
                            <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } ?>
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="#">
                                <div class="d-flex">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="avatar avatar-online">
                                            <?php if ($gender == "Male"){ ?>
                                                <img src="assets/img/avatars/blackboy.png" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } else { ?>
                                                <img src="assets/img/avatars/blackgirl.jpeg" alt class="w-px-40 h-auto rounded-circle" />
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <span class="fw-semibold d-block"><?php echo $firstname.' '.$surname ?></span>
                                        <small class="text-muted"><?php echo $user_role ?></small>
                                    </div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-user me-2"></i>
                                <span class="align-middle">My Profile</span>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bx bx-cog me-2"></i>
                                <span class="align-middle">Settings</span>
                            </a>
                        </li>
                        <li>
                            <div class="dropdown-divider"></div>
                        </li>
                        <li>
                            <a class="dropdown-item" href="logout.php">
                                <i class="bx bx-power-off me-2"></i>
                                <span class="align-middle">Log Out</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <!--/ User -->
            </ul>
        </div>
    </nav>
    <!-- / Navbar -->

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h3 class="card-title text-primary mb-2">Candidate Management</h3>
                                    <p class="mb-0">Manage and monitor all individual candidates in the system</p>
                                </div>
                                <div class="col-md-4 text-md-end">
                                    <button class="btn btn-primary">
                                        <i class="bx bx-plus me-1"></i> Add New Candidate
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Header -->

            <!-- Stats Cards -->
            <div class="row mb-4">
                <div class="col-lg-2 col-md-4 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Total Users</h6>
                                    <h4 class="stat-value"><?php echo $total_number_of_users ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 12%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-primary p-2 rounded">
                                        <i class="bx bx-user bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-2 col-md-4 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Complete Profiles</h6>
                                    <h4 class="stat-value"><?php echo $total_full_registrations ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 8%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-success p-2 rounded">
                                        <i class="bx bx-check-circle bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-2 col-md-4 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">In Progress</h6>
                                    <h4 class="stat-value"><?php echo $total_inprogress_users ?></h4>
                                    <span class="stat-change text-warning"><i class="bx bx-up-arrow-alt"></i> 15%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-warning p-2 rounded">
                                        <i class="bx bx-time bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-2 col-md-4 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Corp. Admin</h6>
                                    <h4 class="stat-value"><?php echo $total_corporate ?></h4>
                                    <span class="stat-change text-info"><i class="bx bx-up-arrow-alt"></i> 5%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-info p-2 rounded">
                                        <i class="bx bx-building bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-2 col-md-4 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">Super Users</h6>
                                    <h4 class="stat-value"><?php echo $total_super_user ?></h4>
                                    <span class="stat-change text-danger"><i class="bx bx-up-arrow-alt"></i> 10%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-danger p-2 rounded">
                                        <i class="bx bx-star bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-2 col-md-4 col-6 mb-4">
                    <div class="card stat-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div class="stat-info">
                                    <h6 class="stat-title">New Today</h6>
                                    <h4 class="stat-value"><?php echo $registrations_today ?></h4>
                                    <span class="stat-change text-success"><i class="bx bx-up-arrow-alt"></i> 3%</span>
                                </div>
                                <div class="stat-icon">
                                    <span class="badge bg-label-secondary p-2 rounded">
                                        <i class="bx bx-trending-up bx-sm"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Stats Cards -->

            <!-- Main Content -->
            <div class="row">
                <!-- Candidates List -->
                <div class="col-lg-12 mb-4">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Candidates List</h5>
                            <div class="d-flex">
                                <div class="me-2">
                                    <select class="form-select form-select-sm">
                                        <option>All Status</option>
                                        <option>Complete</option>
                                        <option>In Progress</option>
                                        <option>New</option>
                                    </select>
                                </div>
                                <button class="btn btn-sm btn-outline-secondary">
                                    <i class="bx bx-filter me-1"></i> Filter
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover" id="bursaries_list">
                                    <thead>
                                        <tr>
                                            <th>Full Names</th>
                                            <th>Email</th>
                                            <th>Progress</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <?php
                                        $api_url = $APIBASE."users/users_exec.php?action=list_user_logging";
                                        $client = curl_init($api_url);
                                        curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
                                        $response = curl_exec($client);
                                        $result = json_decode($response);
                                        
                                        if($result && count($result) > 0) {
                                            foreach($result as $row) {
                                                $url = toURL($row->email);
                                                $progress = (int)$row->profile_ptc;
                                                $status_class = $progress == 100 ? 'success' : ($progress >= 50 ? 'warning' : 'danger');
                                        ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar avatar-sm me-3">
                                                        <?php 
                                                        // You might want to add gender detection logic here
                                                        $avatar = "assets/img/avatars/blackboy.png"; // default
                                                        ?>
                                                        <img src="<?php echo $avatar; ?>" alt class="w-px-30 h-auto rounded-circle" />
                                                    </div>
                                                    <div>
                                                        <div class="fw-semibold"><?php echo $row->firstname.' '.$row->surname ?></div>
                                                        <small class="text-muted">ID: <?php echo substr($row->email, 0, 8) ?>...</small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><?php echo $row->email ?></td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="progress w-px-100 me-2" style="height: 6px;">
                                                        <div class="progress-bar bg-<?php echo $status_class; ?>" role="progressbar" style="width: <?php echo $progress ?>%;" aria-valuenow="<?php echo $progress ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                    <small><?php echo $progress ?>%</small>
                                                </div>
                                            </td>
                                            <td>
                                                <span class="badge bg-label-<?php echo $status_class; ?>">
                                                    <?php echo $progress == 100 ? 'Complete' : ($progress >= 50 ? 'In Progress' : 'New'); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <div class="dropdown">
                                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                        <i class="bx bx-dots-vertical-rounded"></i>
                                                    </button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item" href="view_incomplete_user_details.php?id=<?php echo $url ?>">
                                                            <i class="bx bx-show me-1"></i> View Details
                                                        </a>
                                                        <a class="dropdown-item" href="update_user_account.php?id=<?php echo $url ?>">
                                                            <i class="bx bx-user-pin me-1"></i> User Type
                                                        </a>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="bx bx-envelope me-1"></i> Send Message
                                                        </a>
                                                        <div class="dropdown-divider"></div>
                                                        <a class="dropdown-item text-danger" href="#">
                                                            <i class="bx bx-trash me-1"></i> Delete
                                                        </a>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php       
                                            }
                                        } else {                                
                                        ?>
                                        <tr>
                                            <td colspan="5" align="center" class="py-4">
                                                <div class="d-flex flex-column align-items-center">
                                                    <i class="bx bx-user-x bx-lg text-muted mb-2"></i>
                                                    <p class="text-muted mb-0">No candidates found</p>
                                                    <small class="text-muted">Add new candidates to get started</small>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php       
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <!-- /Main Content -->

            <!-- Active Users Table -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Active Users</h5>
                            <div>
                                <button class="btn btn-sm btn-outline-secondary">
                                    <i class="bx bx-export me-1"></i> Export
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Full Names</th>
                                            <th>Date Of Birth</th>
                                            <th>Email</th>
                                            <th>Whatsapp</th>
                                            <th>Race</th>
                                            <th>Gender</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <?php
                                        $api_url = $APIBASE."users/users_exec.php?action=list_all_system_users_limit";
                                        $client = curl_init($api_url);
                                        curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
                                        $response = curl_exec($client);
                                        $result = json_decode($response);
                                        
                                        if($result && count($result) > 0) {
                                            foreach($result as $row) {
                                                $url = toURL($row->email);
                                        ?>
                                        <tr>
                                            <td><?php echo $row->firstname.' '.$row->surname ?></td>
                                            <td><?php echo $row->date_of_birth ?></td>
                                            <td><?php echo $row->email ?></td>
                                            <td><?php echo $row->whatsapp ?></td>
                                            <td><?php echo $row->race ?></td>
                                            <td><?php echo $row->gender ?></td>
                                            <td>
                                                <div class="dropdown">
                                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                        <i class="bx bx-dots-vertical-rounded"></i>
                                                    </button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item" href="view_user_details.php?id=<?php echo $url ?>">
                                                            <i class="bx bx-show me-1"></i> View
                                                        </a>
                                                        <a class="dropdown-item" href="assign_user_bursary.php?id=<?php echo $url ?>">
                                                            <i class="bx bx-transfer-alt me-1"></i> Bursary
                                                        </a>
                                                        <a class="dropdown-item" href="update_user_account.php?id=<?php echo $url ?>">
                                                            <i class="bx bx-user-pin me-1"></i> User Type
                                                        </a>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php       
                                            }
                                        }                                 
                                        ?>
                                        <tr>
                                            <td colspan="7" align="center">
                                                <a href="users.php?id=<?php echo toURL(rand()) ?>" class="btn btn-sm btn-outline-primary">
                                                    Load More Users
                                                </a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Active Users Table -->
        </div>
        <!-- / Content -->
    </div>
    <!-- Content wrapper -->
</div>
<!-- / Layout page -->

<!-- Custom CSS -->
<style>
.stat-card {
    transition: transform 0.2s, box-shadow 0.2s;
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.stat-title {
    font-size: 0.875rem;
    color: #6c757d;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.stat-change {
    font-size: 0.75rem;
    font-weight: 500;
}

.stat-icon {
    font-size: 1.5rem;
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #6c757d;
    font-size: 0.875rem;
    text-transform: uppercase;
}

.table td {
    vertical-align: middle;
}

.card {
    border: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.card-header {
    border-bottom: 1px solid #e9ecef;
    background-color: white;
}
</style>

<!-- Core JS -->
<script src="assets/vendor/libs/jquery/jquery.js"></script>
<script src="assets/vendor/libs/popper/popper.js"></script>
<script src="assets/vendor/js/bootstrap.js"></script>
<script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/js/menu.js"></script>
<script src="assets/js/main.js"></script>

<!-- Page JS -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize any page-specific JavaScript here
});
</script>
</body>
</html>