<?php 
ob_start(); 
error_reporting(0);
session_start();

include('properties.php');

$encrypted = toURL(rand());
$un_encrypted = $_SESSION['email'];

$api_url = $APIBASE."users/users_exec.php?action=list_user_details&email=".$un_encrypted."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$result = json_decode($response);

if(count($result) > 0){
  foreach($result as $row) {
    $gender = $row->gender;
  }
}

$api_url = $APIBASE."users/users_exec.php?action=user_logging_details_by_email&email=".$un_encrypted."";
$client = curl_init($api_url);
curl_setopt($client, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($client);
$result = json_decode($response);

if(count($result) > 0){
  foreach($result as $row) {        
    $firstname = $row->firstname;
    $surname = $row->surname;
    $email = $row->email;
    $user_role = $row->user_type;
    $bursary_from = $row->bursary_from;
    $profile_ptc = $row->profile_ptc;
  }
}

if ($_SESSION['loggedin'] != TRUE){
  session_unset();
  session_destroy();
  header("refresh:0;url=index.php");
}

$dashboard_link = "dashboard.php?id=".$encrypted;

// Determine profile completion status
$profile_status = '';
$status_class = '';
if($profile_ptc == 100) {
    $profile_status = 'Complete';
    $status_class = 'success';
} elseif($profile_ptc >= 70) {
    $profile_status = 'Almost Complete';
    $status_class = 'info';
} elseif($profile_ptc >= 40) {
    $profile_status = 'In Progress';
    $status_class = 'warning';
} else {
    $profile_status = 'Just Started';
    $status_class = 'secondary';
}
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template-free">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>LevelsUp - Student Dashboard</title>
    <meta name="description" content="Your personalized learning and bursary management platform" />
    <meta http-equiv="refresh" content="9001">

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Icons -->
    <link rel="stylesheet" href="assets/vendor/fonts/boxicons.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/apex-charts/apex-charts.css" />

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <script src="https://code.iconify.design/iconify-icon/1.0.0/iconify-icon.min.js"></script>

    <script src="assets/js/config.js"></script>
    <script src="js/custom.js"></script>

    <style>
    :root {
        --learner-primary: #4361ee;
        --learner-secondary: #3a0ca3;
        --learner-accent: #4cc9f0;
        --learner-success: #4ade80;
        --learner-warning: #facc15;
        --learner-info: #38bdf8;
        --learner-light: #f8fafc;
        --learner-dark: #1e293b;
    }
    
    .learner-bg-primary {
        background-color: var(--learner-primary) !important;
    }
    
    .learner-text-primary {
        color: var(--learner-primary) !important;
    }
    
    .layout-menu {
        background: linear-gradient(135deg, var(--learner-primary) 0%, var(--learner-secondary) 100%);
    }
    
    .menu-inner {
        background: transparent !important;
    }
    
    .menu-link {
        color: rgba(255, 255, 255, 0.8) !important;
        border-radius: 8px;
        margin: 4px 8px;
        transition: all 0.3s ease;
    }
    
    .menu-link:hover, .menu-link.active {
        background-color: rgba(255, 255, 255, 0.1) !important;
        color: white !important;
        transform: translateX(5px);
    }
    
    .menu-item .menu-icon {
        color: rgba(255, 255, 255, 0.7) !important;
    }
    
    .menu-link:hover .menu-icon, .menu-link.active .menu-icon {
        color: white !important;
    }
    
    .app-brand {
        padding: 20px 24px;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }
    
    .user-profile-card {
        background: rgba(255, 255, 255, 0.1);
        border-radius: 12px;
        padding: 16px;
        margin: 16px;
        color: white;
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.1);
    }
    
    .profile-progress {
        height: 6px;
        border-radius: 3px;
        background: rgba(255, 255, 255, 0.2);
        overflow: hidden;
        margin-top: 8px;
    }
    
    .profile-progress-bar {
        height: 100%;
        border-radius: 3px;
        background: white;
        transition: width 0.5s ease;
    }
    
    .menu-header {
        color: rgba(255, 255, 255, 0.6) !important;
        padding: 16px 24px 8px !important;
    }
    
    .layout-navbar {
        background: white;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
    }
    
    .navbar-detached {
        margin: 16px;
        border-radius: 12px;
    }
    </style>
</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo">
                    <a href="<?php echo $dashboard_link ?>" class="app-brand-link">
                    <span class="app-brand-logo demo">
                    </span>
                    <span>
                        <img src="assets/img/logo/logo.png" alt="LevelsApp Logo" width="200" align="left"> 
                    </span>
                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-block d-xl-none">
                    <i class="bx bx-chevron-left bx-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>
                
                <!-- Learner User Profile -->
                <div class="user-profile-card">
                    <div class="d-flex align-items-center">
                        <div class="avatar avatar-sm me-3">
                            <?php if ($gender == "Male"){ ?>
                            <img src="assets/img/avatars/avatar-student-male.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } else { ?>
                            <img src="assets/img/avatars/avatar-student-female.png" alt class="w-px-40 h-auto rounded-circle" />
                            <?php } ?>
                        </div>
                        <div>
                            <div class="fw-semibold text-white"><?php echo $firstname.' '.$surname ?></div>
                            <small class="text-white-50">Student Learner</small>
                        </div>
                    </div>
                    <div class="mt-3">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <small class="text-white-50">Profile Completion</small>
                            <small class="text-white"><?php echo $profile_ptc ?>%</small>
                        </div>
                        <div class="profile-progress">
                            <div class="profile-progress-bar" style="width: <?php echo $profile_ptc ?>%"></div>
                        </div>
                    </div>
                </div>

                <ul class="menu-inner py-1">
                    <!-- Dashboard -->
                    <li class="menu-item active">
                        <a href="<?php echo $dashboard_link ?>" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-home-circle"></i>
                            <div data-i18n="Analytics">Dashboard</div>
                        </a>
                    </li>

                    <li class="menu-header small text-uppercase">
                        <span class="menu-header-text">My Profile</span>
                    </li>            

                    <li class="menu-item">
                        <a href="#" class="menu-link menu-toggle">
                            <i class="menu-icon tf-icons bx bx-user-circle"></i>
                            <div data-i18n="Account Settings">My Profile</div>
                        </a>
                        <ul class="menu-sub">
                            <li class="menu-item">
                                <a href="profile.php?id=<?php echo $encrypted ?>" class="menu-link">
                                    <i class="bx bx-user me-2"></i>
                                    <div data-i18n="Account">Personal Information</div>
                                </a>
                            </li>
                            <li class="menu-item">
                                <a href="profile.php?id=<?php echo $encrypted ?>#academics" class="menu-link">
                                    <i class="bx bx-book-bookmark me-2"></i>
                                    <div data-i18n="Notifications">Academic Information</div>
                                </a>
                            </li>
                            <li class="menu-item">
                                <a href="uploads.php?id=<?php echo $encrypted ?>" class="menu-link">
                                    <i class="bx bx-cloud-upload me-2"></i>
                                    <div data-i18n="Connections">My Uploads</div>
                                </a>
                            </li>
                            <?php if(!empty($bursary_from)){  ?>
                            <li class="menu-item">
                                <a href="bursary_academics_report.php?id=<?php echo $encrypted ?>" class="menu-link">
                                    <i class="bx bx-bar-chart-alt me-2"></i>
                                    <div data-i18n="Connections">Bursary Reports</div>
                                </a>
                            </li>                
                            <?php } ?>
                        </ul>
                    </li>

                    <li class="menu-header small text-uppercase">
                        <span class="menu-header-text">Explore Opportunities</span>
                    </li>

                    <li class="menu-item">
                        <a href="dashboard.php?id=<?php echo $encrypted ?>#intrested_institutions_list" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-building-house"></i>
                            <div data-i18n="Basic">Where to Study</div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="dashboard.php?id=<?php echo $encrypted ?>#intrested_qualification_list" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-graduation"></i>
                            <div data-i18n="Basic">What to Study</div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="bursaries.php?id=<?php echo $encrypted ?>" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-wallet-alt"></i>
                            <div data-i18n="Basic">Bursary Opportunities</div>
                        </a>
                    </li>

                    <li class="menu-header small text-uppercase">
                        <span class="menu-header-text">Resources</span>
                    </li>
                    
                    <li class="menu-item">
                        <a href="#" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-book-open"></i>
                            <div data-i18n="Basic">Study Resources</div>
                        </a>
                    </li>
                    <li class="menu-item">
                        <a href="#" class="menu-link">
                            <i class="menu-icon tf-icons bx bx-calendar-event"></i>
                            <div data-i18n="Basic">Events & Webinars</div>
                        </a>
                    </li>
                </ul>
            </aside>
            <!-- / Menu -->